/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2210;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class Box12XGraphic {
    private GenModel jdm2210Model;
    private GenModel systemModel;
    private GenModel interface2210Model;
    private JdmBrowser jdm2210Browser;
    private Vector interfaceInfo;
    private String resourceFile = "ibm.nways.jdm2210.Resources";
    private int boxType;
    private Point boxPoint = new Point(20, 20);
    private String WCPath = "ibm.nways.jdm2210.WCDefault";
    private static final String PropertiesFile = "properties/jdm2210.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    static final String HelpRef_Dir = "ibm.nways.jdm2210";
    static final String HelpRef_2210html = "ibm.nways.jdm2210.BoxGraphic.html";
    private static final int RASID = 19;
    private static final int RASSUB = 14;

    protected Box12XGraphic(JdmBrowser jdmBrowser, int n) {
        this.jdm2210Browser = jdmBrowser;
        this.boxType = n;
    }

    protected GraphicPanel getGraphicPanel() {
        String string;
        Properties properties;
        Serializable serializable;
        GraphicContainer graphicContainer = new GraphicContainer();
        String string2 = "getGraphicPanel";
        try {
            serializable = new URL(this.jdm2210Browser.getDocumentBase(), PropertiesFile);
            if (RAS.isEnabled(19, 14)) {
                RAS.trace(19, 14, this, string2, "DocumentBase = " + this.jdm2210Browser.getDocumentBase());
            }
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            RAS.logError(19, 14, this, string2, "EXCEPTION_GETTING_PROPERTIES", (Object)PropertiesFile);
            RAS.logException(19, 14, this, string2, exception);
            properties = null;
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdm2210Browser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            if (RAS.isEnabled(19, 14)) {
                RAS.trace(19, 14, this, string2, "The layout scheme property = " + serializable);
            }
            int n = (Integer)serializable;
            jdmLayout.setScheme(n);
            string = (String)((Hashtable)properties).get(fractKey);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logError(19, 14, this, string2, "EXCEPTION_CALCULATING_FRACTIONS");
                    RAS.logException(19, 14, this, string2, (Exception)numberFormatException);
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        this.getBoxInfo();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.jdm2210.Resources");
        if (this.interfaceInfo == null) {
            try {
                this.interfaceInfo = this.interface2210Model.getRestOfInfo("_Empty", "default", null, null);
            }
            catch (Exception exception) {
                RAS.logError(19, 14, this, string2, "EXCEPTION_GETTING_MODELINFO", (Object)"_Empty", (Object)"Jdm2210Model");
                RAS.logException(19, 14, this, string2, exception);
            }
        }
        GraphicImage graphicImage = new GraphicImage(this.jdm2210Browser.imageFrom((Object)this, "box12X.gif"), this.boxPoint, 3, (GraphicAction)new GraphicActionNavigate((GraphicHandler)this.jdm2210Browser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", (RemoteModel)this.systemModel), null), null);
        graphicContainer.add((GraphicComponent)graphicImage);
        serializable = new GraphicHelp((BrowserApplet)this.jdm2210Browser, new Point(0, 0), new HelpRef(HelpRef_Dir, HelpRef_2210html));
        graphicContainer.add((GraphicComponent)serializable);
        if (this.boxType == 16 || this.boxType == 17) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("TOKENRING12X", (ModelInfo)this.interfaceInfo.elementAt(0)));
        } else if (this.boxType == 20 || this.boxType == 21) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("ETHERNET12X", (ModelInfo)this.interfaceInfo.elementAt(0)));
        } else if (this.boxType == 14 || this.boxType == 15) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("TOKENRING12X", (ModelInfo)this.interfaceInfo.elementAt(0)));
            graphicContainer.add((GraphicContainer)this.bakeCookie("ISDN12X", (ModelInfo)this.interfaceInfo.elementAt(3)));
        } else if (this.boxType == 18 || this.boxType == 19) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("ETHERNET12X", (ModelInfo)this.interfaceInfo.elementAt(0)));
            graphicContainer.add((GraphicContainer)this.bakeCookie("ISDN12X", (ModelInfo)this.interfaceInfo.elementAt(3)));
        }
        graphicContainer.add((GraphicContainer)this.bakeCookie("WAN112X", (ModelInfo)this.interfaceInfo.elementAt(1)));
        graphicContainer.add((GraphicContainer)this.bakeCookie("WAN212X", (ModelInfo)this.interfaceInfo.elementAt(2)));
        string = new WidgetCookie("RESETBUTTON12x", this.resourceFile, null, this.WCPath, this.interface2210Model, this.jdm2210Browser, 16, "ibm.nways.jdm2210.eui.Reset2210Panel");
        graphicContainer.add((GraphicContainer)string);
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.jdm2210Browser, (Component)graphicContainer);
        return graphicPanel;
    }

    private void getBoxInfo() {
        String string = "getBoxInfo";
        if (this.systemModel == null) {
            try {
                this.systemModel = (GenModel)this.jdm2210Model.getComponent("System");
                if (RAS.isEnabled(19, 14)) {
                    RAS.trace(19, 14, this, string, "Got system2 model");
                }
            }
            catch (Exception exception) {
                RAS.logError(19, 14, this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"System", (Object)"Jdm2210Model");
                RAS.logException(19, 14, this, string, exception);
            }
        }
        if (this.interface2210Model == null) {
            try {
                this.interface2210Model = (GenModel)this.jdm2210Model.getComponent("Interface");
                if (RAS.isEnabled(19, 14)) {
                    RAS.trace(19, 14, this, string, "Got interface model");
                    return;
                }
            }
            catch (Exception exception) {
                RAS.logError(19, 14, this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Interface", (Object)"Jdm2210Model");
                RAS.logException(19, 14, this, string, exception);
                return;
            }
        }
    }

    protected void setJdm2210Model(GenModel genModel) {
        this.jdm2210Model = genModel;
    }

    protected void setSystemModel(GenModel genModel) {
        this.systemModel = genModel;
    }

    private WidgetCookie bakeCookie(String string, ModelInfo modelInfo) {
        return new WidgetCookie(string, this.resourceFile, modelInfo, this.WCPath, this.interface2210Model, this.jdm2210Browser, 16);
    }
}

